/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xidentos.h
 * -----------------------------------------------------------------*/

#ifndef XIDENTOS_H_INCLUDED
#define XIDENTOS_H_INCLUDED

#include <xpciapi.h>
#include <xtypedef.h>

typedef enum {
    OS_UNIX,
    OS_DOS,
    OS_WIN3X,
    OS_WIN32,       /* only returned in *pCompiledFor */ 
    OS_WIN95,
    OS_WINNT,
    OS_WIN2K,
    OS_DOSW32,
    OS_UNKNOWN
} BX_OS_VERSION;

/* Returns OS and other details as required...
   send null's if you don't want it 
*/

#ifdef __cplusplus
extern "C" {
#endif


BX_OS_VERSION EXPORT GetOsVersion( 
                        char szVersion[80],
                        BX_OS_VERSION * pCompiledFor
                        );

/* Only returns the current OS */

BX_OS_VERSION EXPORT GetOsVersionShort();


#ifdef __cplusplus
}
#endif


#endif  /* IDENTOS_H */
